<h1 class="aside-title"><?php echo e(__('Recent Post')); ?></h1>
<div class="aside-body">
    <?php $__currentLoopData = $recent_posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if( $post->post_title === $recent_posts->first()->post_title ): ?>
            <article class="article-fw">
                <div class="inner">
                    <figure>
                        <a href="<?php echo e(Settings::getRoutePost($post)); ?>">
                            <img src="<?php echo e(Posts::getImage($post->post_content, $post->post_image)); ?>" title="<?php echo e($post->post_image); ?>" alt="<?php echo e($post->post_image); ?>">
                        </a>
                    </figure>
                    <div class="details">
                        <h1><a href="<?php echo e(Settings::getRoutePost($post)); ?>"><?php echo e($post->post_title); ?></a></h1>
                        <?php echo \Str::limit(strip_tags($post->post_content), 100); ?>

                        <div class="detail">
                            <div class="time"><?php echo e($post->created_at->format('F d, Y')); ?></div>
                            <div class="category">
                                <a href="<?php echo e(Settings::getRoutePost($post)); ?>">
                                    <?php echo e(Posts::getCategory($post)); ?>

                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </article>
            <div class="line"></div>
        <?php else: ?>
            <article class="article-mini">
                <div class="inner">
                    <figure>
                        <a href="<?php echo e(Settings::getRoutePost($post)); ?>">
                            <img src="<?php echo e(Posts::getImage($post->post_content, $post->post_image)); ?>" title="<?php echo e($post->post_image); ?>" alt="<?php echo e($post->post_image); ?>">
                        </a>
                    </figure>
                    <div class="padding">
                        <h1>
                            <a href="<?php echo e(Settings::getRoutePost($post)); ?>"><?php echo e($post->post_title); ?></a>
                        </h1>
                        <div class="detail">
                            <div class="category">
                                <a href="<?php echo e(Settings::getRoutePost($post)); ?>">
                                    <?php echo e(Posts::getCategory($post)); ?>

                                </a>
                            </div>
                            <div class="time"><?php echo e($post->created_at->format('F d, Y')); ?></div>
                        </div>
                    </div>
                </div>
            </article>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php /**PATH /home/beeskslz/dallasmosquitoes.com/resources/views/frontend/magz/inc/_recent-post-sidebar.blade.php ENDPATH**/ ?>