<div class="card">
    <div class="card-header">
        <h3 class="card-title"><?php echo e(__('Sessions by device')); ?></h3>
        <div class="card-tools">
            <div class="btn-group">
                <button type="button" class="btn btn-tool dropdown-toggle" data-toggle="dropdown">
                    <?php echo e($label_day); ?>

                </button>
                <div class="dropdown-menu dropdown-menu-right" role="menu" id="session_by_device">
                    <a href="javascript:;" class="dropdown-item choice" onclick="sessionByDevice(0);"><?php echo e(__('Today')); ?></a>
                    <a href="javascript:;" class="dropdown-item choice" onclick="sessionByDevice(1);"><?php echo e(__('Yesterday')); ?></a>
                    <a href="javascript:;" class="dropdown-item choice" onclick="sessionByDevice(7);"><?php echo e(__('Last 7 days')); ?></a>
                    <a href="javascript:;" class="dropdown-item choice" onclick="sessionByDevice(28);"><?php echo e(__('Last 28 days')); ?></a>
                    <a href="javascript:;" class="dropdown-item choice" onclick="sessionByDevice(90);"><?php echo e(__('Last 90 days')); ?></a>
                </div>
            </div>
        </div>
    </div>
    <div class="card-body p-0">
        <!-- Chart's container -->
        <div id="deviceChart" style="height: 300px;"></div>
    </div>
    <div class="card-footer">
        <div class="row">
            <?php if(empty($devices)): ?>
                <div class="col-lg col-<?php echo e($col); ?>">
                    <div class="description-block">
                        <h5 class="description-header">0</h5>
                        <span class="description-text">Desktop</span>
                    </div>
                    <!-- /.description-block -->
                </div>
            <?php else: ?>
                <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $name => $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg col-<?php echo e($col); ?>">
                        <div class="description-block">
                            <h5 class="description-header"><?php echo e($total); ?></h5>
                            <span class="description-text"><?php echo e($name); ?></span>
                        </div>
                        <!-- /.description-block -->
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <!-- /.col -->
            <?php endif; ?>

        </div>
        <!-- /.row -->
    </div>
</div>
<?php /**PATH /home/seoftgxn/pcdrama.com/resources/views/admin/analytics/device.blade.php ENDPATH**/ ?>