<?php $__env->startSection('title', __('Edit Post')); ?>

<?php $__env->startSection('content_header'); ?>
    <?php if (isset($component)) { $__componentOriginal0a31ebec485bff118f9030752f0761d7e5fb0ca0 = $component; } ?>
<?php $component = $__env->getContainer()->make(App\View\Components\Admin\Breadcrumbs::class, ['title' => ''.e(__('Edit Post')).'','currentActive' => ''.e(__('Edit')).'','addLink' => [route('posts.index') => __('Posts')]]); ?>
<?php $component->withName('breadcrumbs'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0a31ebec485bff118f9030752f0761d7e5fb0ca0)): ?>
<?php $component = $__componentOriginal0a31ebec485bff118f9030752f0761d7e5fb0ca0; ?>
<?php unset($__componentOriginal0a31ebec485bff118f9030752f0761d7e5fb0ca0); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<form action="<?php echo e(route('posts.update', [$post->id])); ?>" method="POST" role="form" enctype="multipart/form-data">
<?php echo method_field('PUT'); ?>
<?php echo csrf_field(); ?>
<div class="row">
    <div class="col-md-8">
        <div class="card card-default">
            <div class="card-body">
                <div class="form-group">
                    <label for="titlePost"><?php echo e(__('Title')); ?></label>
                    <input type="text" name="title"
                        class="form-control <?php echo e($errors->has('title') ? 'is-invalid' : ''); ?>" id="titlePost"
                        placeholder="Enter Title" value="<?php echo e(old('title') ? old('title') : $post->post_title); ?>" onkeyup="typeUrl()" required autofocus>
                    <?php if($errors->has('title')): ?>
                    <div class="invalid-feedback">
                        <?php echo e($errors->first('title')); ?>

                    </div>
                    <?php endif; ?>
                </div>
                <div class="form-group">
                    <p>
                        <a class="btn btn-info btn-sm" data-toggle="collapse" href="#collapseSlug" role="button" aria-expanded="false" aria-controls="collapseSlug">
                            <?php echo e(__('Custom Permalink')); ?>

                        </a>
                    </p>
                    <div class="collapse<?php echo e($errors->has('slug') ? ' show' : ''); ?>" id="collapseSlug">
                        <input type="text" name="slug"
                               class="form-control <?php echo e($errors->has('slug') ? 'is-invalid' : ''); ?>" id="slugPost"
                               placeholder="Enter Slug" value="<?php echo e(old('slug') ? old('slug') : $post->post_name); ?>">
                        <?php if($errors->has('slug')): ?>
                            <div class="invalid-feedback">
                                <?php echo e($errors->first('slug')); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="form-group">
                    <label for="summaryPost"><?php echo e(__('Summary')); ?></label>
                    <textarea id="summaryPost" name="summary" class="form-control" rows="3" placeholder="<?php echo e(__('Enter summary')); ?>"><?php echo e($post->post_summary); ?></textarea>
                </div>
                <div class="form-group">
                    <label for="contentPost"><?php echo e(__('Content')); ?></label>
                    <textarea id="contentPost" name="content" placeholder="<?php echo e(__('Place some text here')); ?>" style="width: 100%; height: 200px; font-weight:normal"><?php echo e($post->post_content); ?></textarea>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card card-default">
            <div class="card-body">
                <div class="form-group">
                    <label for="categories"><?php echo e(__('Select Categories')); ?></label>
                    <select id="categories" name="categories[]" class="select2" multiple="multiple"
                        data-placeholder="Choose.." style="width: 100%;">
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($category->id); ?>" selected="selected"><?php echo e($category->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <small class="form-text text-muted">
                        <?php echo e(__('Click or press enter to select')); ?>

                    </small>
                </div>
                <div class="form-group">
                    <label for="tagsinput"><?php echo e(__('Select Tags')); ?></label>
                    <select id="tagsinput" name="tags[]" class="select2" multiple="multiple" data-placeholder="Choose.."
                        style="width: 100%;">
                        <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($tag->id); ?>" selected="selected"><?php echo e($tag->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <small class="form-text text-muted">
                        <?php echo e(__('Click or press enter to select')); ?>

                    </small>
                </div>
                <div class="form-group">
                    <label for="upload"><?php echo e(__('Featured Image')); ?></label>
                    <div class="upload-photo <?php if(!empty($post->post_image)): ?>ready <?php endif; ?>">
                        <input id="upload" type="file" name="image" value="Choose a file" accept="image/*" data-role="none" hidden>
                        <input type="hidden" name="isimage">
                        <div class="col-md-12">
                            <div class="upload-msg"><?php echo e(__('Click to upload image')); ?></div>
                            <div id="display">
                                <img id="image_preview_container" src="<?php echo e($image); ?>" name="image" alt="preview image"
                                    style="width: 100%;">
                            </div>
                            <div class="buttons text-center mt-3">
                                <button id="reset" type="button" class="reset btn btn-danger"><?php echo e(__('Remove Image')); ?></button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="meta_description"><?php echo e(__('Meta Description')); ?></label>
                    <textarea id="meta_description" name="meta_description" class="form-control" rows="3"
                              placeholder="<?php echo e(__('Enter desciption post')); ?>"><?php echo e($post->meta_description); ?></textarea>
                </div>
                <div class="form-group">
                    <label for="meta_keyword"><?php echo e(__('Meta Keyword')); ?></label>
                    <textarea id="meta_keyword" name="meta_keyword" class="form-control" rows="3"
                              placeholder="<?php echo e(__('Enter keyword post')); ?>"><?php echo e($post->meta_keyword); ?></textarea>
                </div>
            </div>
        </div>
        <div class="card card-default">
            <div class="card-header"><?php echo e(__('Publish')); ?></div>
            <div class="card-body">
                <div class="form-group">
                    <label><?php echo e(__('Visibility')); ?></label>
                    <select id="visibility" class="form-control" name="visibility">
                        <?php if($visibility == 'public'): ?>
                            <option id="public" value="public" selected><?php echo e(__('Public')); ?></option>
                            <option id="private" value="private"><?php echo e(__('Private')); ?></option>
                        <?php else: ?>
                            <option id="public" value="public"><?php echo e(__('Public')); ?></option>
                            <option id="private" value="private" selected><?php echo e(__('Private')); ?></option>
                        <?php endif; ?>
                    </select>
                    <small class="form-text text-muted visibility-msg">
                        <?php echo e(__('Visible to everyone')); ?>

                    </small>
                </div>
                <div class="form-group">
                    <input class="btn btn-primary" type="submit" name="publish" value="<?php echo e(__('Publish')); ?>">
                    <input class="btn btn-secondary" type="submit" name="draft" value="<?php echo e(__('Save as Draft')); ?>">
                </div>
            </div>
        </div>
    </div>
</div>
</form>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('adminlte_css'); ?>
<link rel="stylesheet" href="<?php echo e(asset('vendor/select2/css/select2.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/pace-progress/themes/blue/pace-theme-minimal.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/summernote/summernote-bs4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('vendor/summernote-add-text-tags/summernote-add-text-tags.css')); ?>">
<?php echo $__env->make('admin.post.style', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php $__env->startSection('adminlte_js'); ?>
<script src="<?php echo e(asset('vendor/select2/js/select2.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/summernote/summernote-bs4.min.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/summernote-image-attributes-editor/summernote-image-attributes.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/summernote-image-attributes-editor/lang/en-us.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/summernote-add-text-tags/summernote-add-text-tags.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/summernote-ext-highlight/summernote-ext-highlight.js')); ?>"></script>
<script src="<?php echo e(asset('vendor/summernote-video-attributes/summernote-video-attributes.js')); ?>"></script>
<?php echo $__env->make('layouts.partials._notification', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.partials._csrf-token', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('admin.post.script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<script>
    "use strict";

    // VISIBILITY
    let indexVisible = document.getElementById("visibility").selectedIndex;
    let infor = []
    infor[0] = "<?php echo e(__('Visible to everyone')); ?>";
    infor[1] = "<?php echo e(__('Visible only to the role superadmin, admin, and post owner')); ?>";
    $(".visibility-msg").html(infor[indexVisible]);

    // UPLOAD IMAGE
    const element = document.querySelector(".upload-photo");
    $('input[name=isimage]').val(element.classList.contains("ready"));

    $('.upload-msg').on("click", function() {
        $("#upload").trigger("click");
    });

    $('#reset').on("click", function() {
        $('#display').removeAttr('hidden');
        $('#reset').attr('hidden');
        $('.upload-photo').removeClass('ready result');
        $('#image_preview_container').attr('src', '<?php echo e(asset('images/noimage.png')); ?>');
        $('input[name=isimage]').val("false");
    });

    function readFile(input) {
        let reader = new FileReader();
        reader.onload = (e) => {
            $('.upload-photo').addClass('ready');
            $('#image_preview_container').attr('src', e.target.result);
            $('input[name=isimage]').val("true");
        }
        reader.readAsDataURL(input.files[0]);
    }

    $('#upload').on('change', function() {
        readFile(this);
    });
</script>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.partials._footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/seoftgxn/pcdrama.com/resources/views/admin/post/edit.blade.php ENDPATH**/ ?>