<?php $__env->startSection('content'); ?>
<section class="tag">
    <div class="container">
        <div class="row">
            <div class="col-md-8 text-left">
                <div class="row">
                    <div class="col-md-12">
                        <ol class="breadcrumb">
                            <li><a href="/"><?php echo e(__('Home')); ?></a></li>
                            <li class="active"><?php echo e($term->name); ?></li>
                        </ol>
                        <h1 class="page-title">tag: <?php echo e($term->name); ?></h1>
                        <p class="page-subtitle"><?php echo e(__('Showing all posts with tag')); ?> <i><?php echo e($term->name); ?></i></p>
                    </div>
                </div>
                <div class="line"></div>
                <div class="row">
                    <?php $__currentLoopData = $termTaxonomy->post; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <article class="col-md-12 article-list">
                        <div class="inner">
                            <figure>
                                <a href="<?php echo e(Settings::getRoutePost($post)); ?>">
                                    <img src="<?php echo e(Posts::getImage($post->post_content, $post->post_image)); ?>" alt="<?php echo e($post->post_image); ?>" alt="<?php echo e($post->post_image); ?>">
                                </a>
                            </figure>
                            <div class="details">
                                <div class="detail">
                                    <div class="category">
                                        <a href="<?php echo e(route('category.show', Posts::getLinkCategory($post))); ?>">
                                            <?php echo e(Posts::getCategory($post)); ?>

                                        </a>
                                    </div>
                                    <div class="time"><?php echo e($post->created_at->format('F d, Y')); ?></div>
                                </div>
                                <h1><a href="<?php echo e(Settings::getRoutePost($post)); ?>"><?php echo e($post->post_title); ?></a></h1>
                                <p><?php echo \Str::limit(strip_tags($post->post_content), 100); ?></p>
                                <footer>
                                    <a href="javascript:void(0);" class="love" data-id="<?php echo e($hashids->encode($post->id)); ?>"><i class="ion-android-favorite-outline"></i>
                                        <div><?php echo e($post->like); ?></div>
                                    </a>
                                    <a class="btn btn-primary more" href="<?php echo e(Settings::getRoutePost($post)); ?>">
                                        <div><?php echo e(__('More')); ?></div>
                                        <div><i class="ion-ios-arrow-thin-right"></i></div>
                                    </a>
                                </footer>
                            </div>
                        </div>
                    </article>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-12 text-center">
                        <?php echo e($paginate->links('frontend.magz.inc._pagination')); ?>

                    </div>
                </div>
            </div>
            <div class="col-md-4 sidebar">
                <?php echo $__env->make('frontend.magz.template-parts.sidebar-posts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.magz.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/netsitfw/public_html/resources/views/frontend/magz/page/tag.blade.php ENDPATH**/ ?>