<script>
$(function () {
    "use strict";

    // VISIBILITY
    $(document).on('change', '#visibility', function(){
        let indexVisible = document.getElementById("visibility").selectedIndex;
        let info = []
        info[0] = "<?php echo e(__('Visible to everyone')); ?>";
        info[1] = "<?php echo e(__('Visible only to the role superadmin, admin, and post owner')); ?>";
        $(".visibility-msg").html(info[indexVisible]);
    });

    // SELECT OPTION
    $('#categories').select2({
        theme: 'bootstrap4',
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add-categories')): ?> tags: 'true', <?php endif; ?>
        tokenSeparators: [','],
        ajax: {
            url: "<?php echo e(route('categories.search')); ?>",
            processResults: function(data) {
                return {
                    results: data.map(function(item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                }
            }
        },
        createSearchChoice: function(item, data) {
            if ($(data).filter(function() {
                    return this.text.localeCompare(item) === 0;
                }).length === 0) {
                return {
                    id: item,
                    text: item
                }
            }
        },
        escapeMarkup: function(m) {
            return m.match(/[a-zA-Z0-9 ]+/g);
        }
    });

    $('#tagsinput').select2({
        theme: 'bootstrap4',
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('add-categories')): ?> tags: 'true', <?php endif; ?>
        tokenSeparators: [','],
        ajax: {
            url: "<?php echo e(route('tags.search')); ?>",
            processResults: function(data) {
                return {
                    results: data.map(function(item) {
                        return {
                            id: item.id,
                            text: item.name
                        }
                    })
                }
            }
        },
        createSearchChoice: function(item, data) {
            if ($(data).filter(function() {
                    return this.text.localeCompare(item) === 0;
                }).length === 0) {
                return {
                    id: item,
                    text: item
                }
            }
        },
        escapeMarkup: function(m) {
            return m.match(/[a-zA-Z0-9 ]+/g);
        }
    });

    // TEXT EDITOR
    $('textarea[name=content]').summernote({
        placeholder: 'Write here..',
        height: 300,
        styleTags: [
        'p',
        { title: 'Blockquote', tag: 'blockquote', className: 'blockquote', value: 'blockquote' },
        'h1', 'h2', 'h3', 'h4', 'h5', 'h6'
        ],
        prettifyHtml: true,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'italic', 'underline', 'add-text-tags', 'highlight', 'clear']],
            ['font', ['strikethrough', 'superscript', 'subscript']],
            ['fontsize', ['fontsize']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['insert', ['link', 'picture', 'videoAttributes']],
            ['view', ['fullscreen', 'codeview', 'help']],
        ],
        imageAttributes: {
          	icon: '<i class="note-icon-pencil"/>',
        	figureClass: 'figureClass',
        	figcaptionClass: 'captionClass',
        	captionText: 'Caption Goes Here.',
        	manageAspectRatio: true // true = Lock the Image Width/Height, Default to true
        },
        lang: 'en-US',
        popover: {
            image: [
                ['imagesize', ['imageSize100', 'imageSize50', 'imageSize25']],
                ['float', ['floatLeft', 'floatRight', 'floatNone']],
                ['remove', ['removeMedia']],
                ['custom', ['imageAttributes']],
            ],
        },
        callbacks: {
            onImageUpload: function(image) {
                let editor;
                editor = $(this);
                uploadImageContent(image[0], editor);
            },
            onMediaDelete: function(target) {
                deleteImage(target[0].src);
            }
        },
    });

    $('textarea[name=summary]').summernote({
        placeholder: 'Summary..',
        height: 100,
        tabsize: 1,
        toolbar: [
            ['style', ['bold', 'italic', 'underline', 'clear']],
            ['font', ['strikethrough', 'superscript', 'subscript']],
        ],
    });

    function uploadImageContent(image, editor) {
        let data = new FormData();
        data.append("image", image);
        $.ajax({
            url: "<?php echo e(route('uploadImage')); ?>",
            cache: false,
            contentType: false,
            processData: false,
            data: data,
            type: "post",
            success: function(url) {
                let image = $('<img>').attr('src', url);
                $(editor).summernote("insertNode", image[0]);
            },
            error: function(data) {}
        })
    }

    function deleteImage(src) {
        $.ajax({
            data: {
                image: src
            },
            type: "POST",
            url: "<?php echo e(route('removeUploadImage')); ?>",
            cache: false,
            success: function(response) {}
        });
    }
});

function slugify(text) {
    return text.toString().toLowerCase()
        .replace(/\s+/g, '-') // Replace spaces with -
        .replace(/\./g, '-') // Replace dot with -
        .replace(/[^\w\-]+/g, '') // Remove all non-word chars
        .replace(/\-\-+/g, '-') // Replace multiple - with single -
        .replace(/^-+/, '') // Trim - from start of text
        .replace(/-+$/, ''); // Trim - from end of text
}

function typeUrl() {
    if (document.getElementById("titlePost").value === "") {
        document.getElementById("slugPost").value = "";
    } else {
        let x = document.getElementById("titlePost").value;
        let slug = slugify(x);
        document.getElementById("slugPost").value = slug;
    }
}

</script>
<?php /**PATH /home/seoftgxn/pcdrama.com/resources/views/admin/post/script.blade.php ENDPATH**/ ?>