<div class="tab-pane fade" id="web-permalinks" role="tabpanel" aria-labelledby="web-permalinks-tab">
    <form id="form-web-permalinks" action="<?php echo e(route('settings.update')); ?>" method="POST" role="form">
        <?php echo method_field('PATCH'); ?>
        <?php echo csrf_field(); ?>
        <input type="hidden" name="web_permalinks">
        <h5><?php echo e(__('Post Permalinks')); ?></h5>
        <hr>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="postname" name="permalink" value="post_name" <?php echo e($settings->permalink === 'post_name' ? 'checked' : ''); ?>>
                <label for="postname">
                    Post name
                </label>
                <code><?php echo e(url('/')); ?>/sample-post</code>
            </div>
        </div>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="dayandname" name="permalink" value="%year%/%month%/%day%" <?php echo e($settings->permalink === '%year%/%month%/%day%' ? 'checked' : ''); ?>>
                <label for="dayandname">
                    Day and name
                </label>
                <code><?php echo e(url('/')); ?>/<?php echo e(now()->year); ?>/<?php echo e(now()->month); ?>/<?php echo e(now()->day); ?>/sample-post</code>
            </div>
        </div>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="monthandname" name="permalink" value="%year%/%month%" <?php echo e($settings->permalink === '%year%/%month%' ? 'checked' : ''); ?>>
                <label for="monthandname">
                    Month and name
                </label>
                <code><?php echo e(url('/')); ?>/<?php echo e(now()->year); ?>/<?php echo e(now()->month); ?>/sample-post</code>
            </div>
        </div>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="custom" name="permalink" value="custom" <?php echo e(Settings::get('permalink_type') === 'custom' ? 'checked' : ''); ?>>
                <label for="custom">
                    Custom
                </label>
                <code><?php echo e(url('/')); ?>/</code>
                <?php if(Settings::get('permalink_type') == 'custom'): ?>
                    <input type="text" value="<?php echo e(Settings::get('permalink')); ?>" name="custom_input">
                <?php else: ?>
                    <input type="text" value="<?php echo e(Settings::get('permalink_old')); ?>" name="custom_input">
                <?php endif; ?>

                <code>/sample-post</code>
            </div>
        </div>

        <div class="row mt-3">&nbsp;</div>

        <h5><?php echo e(__('Page Permalinks')); ?></h5>
        <hr>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="pagename" name="page_permalink" value="page_name" <?php echo e($settings->permalink_page === 'page_name' ? 'checked' : ''); ?>>
                <label for="pagename">
                    Page name
                </label>
                <code><?php echo e(url('/')); ?>/sample-page</code>
            </div>
        </div>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="withprefix" name="page_permalink" value="with_prefix" <?php echo e($settings->permalink_page === 'with_prefix' ? 'checked' : ''); ?>>
                <label for="withprefix">
                    With prefix
                </label>
                <code><?php echo e(url('/')); ?>/page/sample-page</code>
            </div>
        </div>

        <div class="row mt-3">&nbsp;</div>

        <h5><?php echo e(__('Category Permalinks')); ?></h5>
        <hr>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="categoryname" name="category_permalink" value="category_name" <?php echo e($settings->permalink_category === 'category_name' ? 'checked' : ''); ?>>
                <label for="categoryname">
                    Category name
                </label>
                <code><?php echo e(url('/')); ?>/sample-category</code>
            </div>
        </div>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="withprefixcategory" name="category_permalink" value="with_prefix_category" <?php echo e($settings->permalink_category === 'with_prefix_category' ? 'checked' : ''); ?>>
                <label for="withprefixcategory">
                    With prefix
                </label>
                <code><?php echo e(url('/')); ?>/category/sample-category</code>
            </div>
        </div>

        <div class="mt-3">
            <button id="submit-web-permalinks" type="submit" class="btn btn-info float-right"><?php echo e(__('Save')); ?></button>
        </div>
    </form>
</div>
<?php /**PATH /home/beeskslz/dallasmosquitoes.com/resources/views/admin/setting/web-permalinks.blade.php ENDPATH**/ ?>