<?php if(count(Posts::lastWeekPosts()->get())): ?>
<section class="best-of-the-week">
    <div class="container">
        <h1>
            <div class="text"><?php echo e(__('Best Of The Week')); ?></div>
            <div class="carousel-nav" id="best-of-the-week-nav">
                <div class="prev">
                    <i class="ion-ios-arrow-left"></i>
                </div>
                <div class="next">
                    <i class="ion-ios-arrow-right"></i>
                </div>
            </div>
        </h1>
        <div class="owl-carousel owl-theme carousel-1">
            <?php $__currentLoopData = Posts::lastWeekPosts()->limit(6)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <article class="article">
                <div class="inner">
                    <figure>
                        <a href="<?php echo e(Settings::getRoutePost($post)); ?>">
                            <img src="<?php echo e(Posts::getImage($post->post_content, $post->post_image)); ?>" title="<?php echo e($post->post_image); ?>" alt="<?php echo e($post->post_image); ?>">
                        </a>
                    </figure>
                    <div class="padding">
                        <div class="detail">
                            <div class="time"><?php echo e($post->created_at->format('F d, Y')); ?></div>
                            <div class="category"><a href="<?php echo e(route('category.show', Posts::getLinkCategory($post))); ?>"><?php echo e(Posts::getCategory($post)); ?></a>
                            </div>
                        </div>
                        <h2><a href="<?php echo e(Settings::getRoutePost($post)); ?>"><?php echo e(\Str::limit($post->post_title, 50)); ?></a>
                        </h2>
                        <?php echo \Str::limit(strip_tags($post->post_content), 100); ?>

                    </div>
                </div>
            </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php endif; ?>
<?php /**PATH /home/seoftgxn/pcdrama.com/resources/views/frontend/magz/inc/_best-of-the-week.blade.php ENDPATH**/ ?>