<h1 class="title-col">
    <?php echo e(__('Hot News')); ?>

    <div class="carousel-nav" id="hot-news-nav">
        <div class="prev">
            <i class="ion-ios-arrow-left"></i>
        </div>
        <div class="next">
            <i class="ion-ios-arrow-right"></i>
        </div>
    </div>
</h1>
<div class="body-col vertical-slider" data-max="4" data-nav="#hot-news-nav" data-item="article">
    <?php $__currentLoopData = Posts::popularPosts()->limit(4)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <article class="article-mini">
        <div class="inner">
            <figure>
                <a href="<?php echo e(Settings::getRoutePost($post)); ?>">
                    <img src="<?php echo e(Posts::getImage($post->post_content, $post->post_image)); ?>"
                        title="<?php echo e($post->post_image); ?>" alt="<?php echo e($post->post_image); ?>">
                </a>
            </figure>
            <div class="padding">
                <h1><a href="<?php echo e(Settings::getRoutePost($post)); ?>"><?php echo e($post->post_title); ?></a></h1>
                <div class="detail">
                    <div class="category">
                        <a href="<?php echo e(route('category.show', Posts::getLinkCategory($post))); ?>">
                            <?php echo e(Posts::getCategory($post)); ?>

                        </a>
                    </div>
                    <div class="time"><?php echo e($post->created_at->format('F d, Y')); ?></div>
                </div>
            </div>
        </div>
    </article>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
<?php /**PATH /home/mithun/Documents/projects/20220128_pcdrama/resources/views/frontend/magz/inc/_hot-news.blade.php ENDPATH**/ ?>