<div class="tab-pane fade" id="web-contact" role="tabpanel" aria-labelledby="web-contact-tab">
    <form id="form-web-contact" action="" method="POST" role="form">
        <?php echo method_field('PATCH'); ?>
        <?php echo csrf_field(); ?>
        <input type="hidden" name="web_contact">
        <div class="row">
            <div class="col-lg-12">
                <div class="form-group">
                    <label for="street"><?php echo e(__('Street')); ?></label>
                    <input id="street" type="text" name="street" class="form-control" placeholder="<?php echo e(__('Street')); ?>" value="<?php echo e($settings->street); ?>">
                    <div class="msg-street"></div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="city"><?php echo e(__('City')); ?></label>
                    <input id="city" type="text" name="city" class="form-control" placeholder="<?php echo e(__('City')); ?>" value="<?php echo e($settings->city); ?>">
                    <div class="msg-city"></div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="postal_code"><?php echo e(__('Postal Code')); ?></label>
                    <input id="postal_code" type="text" name="postal_code" class="form-control" placeholder="<?php echo e(__('Postal Code')); ?>" value="<?php echo e($settings->postal_code); ?>">
                    <div class="msg-postal_code"></div>
                </div>
            </div>

            <div class="col-lg-6">
                <div class="form-group">
                    <label for="state"><?php echo e(__('State')); ?></label>
                    <input id="state" type="text" name="state" class="form-control" placeholder="<?php echo e(__('State')); ?>" value="<?php echo e($settings->state); ?>">
                    <div class="msg-state"></div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="country"><?php echo e(__('Country')); ?></label>
                    <input id="country" type="text" name="country" class="form-control" placeholder="<?php echo e(__('Country')); ?>" value="<?php echo e($settings->country); ?>">
                    <div class="msg-country"></div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="contactdescription"><?php echo e(__('Full Address (Optional)')); ?></label>
                    <textarea id="fulladdress" name="fulladdress" class="form-control" rows="3" placeholder="<?php echo e(__('Full Address')); ?>"><?php echo nl2br( $settings->fulladdress ); ?></textarea>
                    <div class="msg-fulladdress"></div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="sitephone"><?php echo e(__('Phone Number')); ?></label>
                    <input id="sitephone" type="text" name="sitephone" class="form-control" placeholder="<?php echo e(__('Phone Number')); ?>" value="<?php echo e($settings->sitephone); ?>">
                    <div class="msg-sitephone"></div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="contactdescription"><?php echo e(__('Form Contact Description')); ?></label>
                    <textarea id="contactdescription" name="contactdescription"
                              class="form-control" rows="3" placeholder="<?php echo e(__('Contact description')); ?>"><?php echo nl2br( $settings->contactdescription ); ?></textarea>
                    <div class="msg-contactdescription"></div>
                </div>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="siteemail"><?php echo e(__('E-Mail')); ?></label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fas fa-envelope"></i></span>
                        </div>
                        <input id="siteemail" type="email" name="siteemail"
                               class="form-control" placeholder="name@domain.com"
                               value="<?php echo e($settings->siteemail); ?>">
                        <div class="msg-siteemail"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="facebook"><?php echo e(__('Facebook')); ?></label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fab fa-facebook"></i></span>
                        </div>
                        <input id="facebook" type="text" name="facebook" class="form-control" placeholder="@username" value="<?php echo e($settings->facebook); ?>">
                        <div class="msg-facebook"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="twitter"><?php echo e(__('Twitter')); ?></label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fab fa-twitter"></i></span>
                        </div>
                        <input id="twitter" type="text" name="twitter" class="form-control" placeholder="@username" value="<?php echo e($settings->twitter); ?>">
                        <div class="msg-twitter"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="youtube"><?php echo e(__('Youtube')); ?></label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fab fa-youtube"></i></span>
                        </div>
                        <input id="youtube" type="text" name="youtube" class="form-control" placeholder="@channel" value="<?php echo e($settings->youtube); ?>">
                        <div class="msg-youtube"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="instagram"><?php echo e(__('Instagram')); ?></label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fab fa-instagram"></i></span>
                        </div>
                        <input id="instagram" type="text" name="instagram" class="form-control" placeholder="@username" value="<?php echo e($settings->instagram); ?>">
                        <div class="msg-instagram"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="instagram"><?php echo e(__('LinkedIn')); ?></label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fab fa-linkedin"></i></span>
                        </div>
                        <input id="linkedin" type="text" name="linkedin" class="form-control" placeholder="@username" value="<?php echo e($settings->linkedin); ?>">
                        <div class="msg-linkedin"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="instagram"><?php echo e(__('Telegram')); ?></label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fab fa-telegram"></i></span>
                        </div>
                        <input id="telegram" type="text" name="telegram" class="form-control" placeholder="Mobile Number/@username" value="<?php echo e($settings->telegram); ?>">
                        <div class="msg-telegram"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="form-group">
                    <label for="instagram"><?php echo e(__('WhatsApp')); ?></label>
                    <div class="input-group mb-3">
                        <div class="input-group-prepend">
                            <span class="input-group-text"><i class="fab fa-whatsapp"></i></span>
                        </div>
                        <input id="whatsapp" type="text" name="whatsapp" class="form-control" placeholder="Mobile Number" value="<?php echo e($settings->whatsapp); ?>">
                        <div class="msg-whatsapp"></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="mt-3">
            <button id="submit-web-contact" type="submit" class="btn btn-info float-right"><?php echo e(__('Save')); ?></button>
        </div>
    </form>
</div>
<?php /**PATH /home/beeskslz/dallasmosquitoes.com/resources/views/admin/setting/web-contact.blade.php ENDPATH**/ ?>