<?php $__env->startSection(config('mail-tracker.admin-template.section')); ?>
    <div class="container">
        <div class="row">
            <div class="col-sm-12 mt-2">
                <h1 class="mt-2 pt-2">Mail Tracker  <?php if(\File::exists(public_path('exports/users-collection.xlsx'))): ?> <a href="<?php echo e(route('download-export')); ?>" class="btn btn-success float-right">Download Export</a>  <?php endif; ?></h1>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <h4 class="text-center">
                    SNS Endpoint: <?php echo e(route('mailTracker_SNS')); ?>

                </h4>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 text-center">
                <form action="<?php echo e(route('mailTracker_Search')); ?>" method="post" class="form-inline">
                    <?php echo csrf_field(); ?>

                    <div class="form-group">
                        <label for="search">
                            Search
                        </label>
                        <input type="text" name="search" id="search" value="<?php echo e(session('mail-tracker-index-search')); ?>">
                    </div>
                    <button type="submit" class="btn btn-default">
                        Search
                    </button>
                    <div class="btn btn-default">
                        <a href="<?php echo e(route('mailTracker_ClearSearch')); ?>">
                            Clear Search
                        </a>
                    </div>
                </form>
                <hr>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <table class="table table-striped">
                    <tr>
                        <th>Created At</th>
                        <th>Opened At</th>
                        <th>Recipient</th>
                        <th>Opens</th>
                        <th>First Click</th>
                        <th>Clicks</th>
                        <th>Subject</th>
                        <th>Service</th>


                        <th>Name</th>
                        <th>Location</th>
                        <th>Phone</th>


                        <th>View Email</th>
                        <th>Click Report</th>
                    </tr>
                <?php $__currentLoopData = $emails; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $email): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="<?php echo e($email->report_class); ?>">
                        <td><?php echo e($email->created_at->format(config('mail-tracker.date-format'))); ?></td>
                        <td><?php echo e($email->opened_at); ?></td>
                        <td><?php echo e($email->recipient); ?></td>
                        <td><?php echo e($email->opens); ?></td>
                        <td><?php echo e($email->clicked_at); ?></td>
                        <td><?php echo e($email->clicks); ?></td>
                        <td><?php echo e($email->subject); ?></td>
                        <td><?php echo e($email->service); ?></td>

                        <?php if($email->msg): ?>
                            <td><?php echo e($email->msg->name); ?></td>
                            <td><a href="https://www.google.com/maps/place/<?php echo e($email->msg->geolocation); ?>" target="_blank"><?php echo e($email->msg->Location); ?></a></td>
                            <td><?php echo e($email->msg->phone); ?></td>
                        <?php else: ?>
                            <td></td>
                            <td></td>
                            <td></td>
                        <?php endif; ?>

                        <td>
                            <a href="<?php echo e(route('mailTracker_ShowEmail',$email->id)); ?>" target="_blank">
                                View
                            </a>
                        </td>
                        <td>
                            <?php if($email->clicks > 0): ?>
                                <a href="<?php echo e(route('mailTracker_UrlDetail',$email->id)); ?>">Url Report</a>
                            <?php else: ?>
                                No Clicks
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 text-center">
                <?php echo $emails->render(); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('adminlte::page', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mithun/Documents/projects/20220128_pcdrama/resources/views/vendor/emailTrakingViews/index.blade.php ENDPATH**/ ?>