<script>
    "use strict";

    toastr.options.closeButton = true;

    <?php if(session('success')): ?>
    notify('success', "<?php echo e(session('success')); ?>")
    <?php endif; ?>

    <?php if(session('info')): ?>
    notify("info", "<?php echo e(session('info')); ?>")
    <?php endif; ?>

    <?php if(session('error')): ?>
    notify("error", "<?php echo e(session('error')); ?>")
    <?php endif; ?>

    // success, error, info
    function notify(sign, message) {
        const sessionId = "<?php echo e(uniqid()); ?>";
        if (sessionStorage) {
            if (!sessionStorage.getItem('shown-' + sessionId)) {
                if (sign ===  "success") {
                    success(message)
                }
                if (sign === "error") {
                    error(message)
                }
                if (sign === "info") {
                    info(message)
                }
            }
            sessionStorage.setItem('shown-' + sessionId, '1');
        }
    }

    function success(message) {
        toastr.success(message);
    }

    function error(message) {
        toastr.error(message);
    }

    function info(message) {
        toastr.info(message);
    }

    // Toast
    const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000
    });

    function alert_sweet_success(message) {
        Toast.fire({
            icon: 'success',
            type: 'success',
            title: message
        });
    }

    function alert_sweet_error(message) {
        Toast.fire({
            icon: 'error',
            type: 'error',
            title: message
        });
    }
</script>
<?php /**PATH /home/netsitfw/public_html/resources/views/layouts/partials/_notification.blade.php ENDPATH**/ ?>