<div class="line thin"></div>
<div class="page-description">
    <div class="row">
        <div class="col-md-6 col-sm-6">
            <h3>Contact <?php echo e(config('app.name')); ?></h3>
            <p>
                <?php echo e(Settings::get('contactdescription')); ?>

            </p>
            <p>
                <?php echo e(__('Phone')); ?>: <span class="bold"><a href="tel:<?php echo e(str_replace('-', '', Settings::get('sitephone'))); ?>"><?php echo e(Settings::get('sitephone')); ?></a></span> <br>
                <?php echo e(__('Email')); ?>: <span class="bold"><a href="mailto:<?php echo e(Settings::get('siteemail')); ?>"><?php echo e(Settings::get('siteemail')); ?></a></span>
                <br>
                <br>
                <p>
                    <?php echo e(Settings::get('street')); ?> <br><br> 
                    <?php echo e(Settings::get('city') .' '. Settings::get('postal_code')); ?> <br>
                    <?php echo e(Settings::get('state') .' - '. Settings::get('country')); ?>

                </p>

            </p>
        </div>
        <div class="col-md-6 col-sm-6">
            <form class="row contact" id="contact-form" method="POST" role="form" data-recaptcha="true" enctype="multipart/form-data">
                <div class="col-md-6">
                    <div class="form-group form-group-name">
                        <label><?php echo e(__('Name')); ?> <span class="required"></span></label>
                        <input type="name" class="form-control" id="name" name="name" required>
                        <span id="msg-error-name" class="help-block"></span>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group form-group-email">
                        <label><?php echo e(__('Email')); ?> <span class="required"></span></label>
                        <input type="email" class="form-control" id="email" name="email" required>
                        <span id="msg-error-email" class="help-block"></span>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group form-group-subject">
                        <label><?php echo e(__('Subject')); ?></label>
                        <input type="subject" class="form-control" id="subject" name="subject">
                        <span id="msg-error-subject" class="help-block"></span>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group form-group-subject">
                        <label><?php echo e(__('Phone Number')); ?></label>
                        <input type="phone" class="form-control" id="phone" name="phone">
                        <span id="msg-error-phone" class="help-block"></span>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group form-group-subject">
                        <label><?php echo e(__('Choose Service')); ?></label>
                        <div class="d-flex" style="display: flex;">
							<?php $__currentLoopData = Posts::tagCount()->skip(0)->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div style="margin-right: 10px;" >
                                <label for="">
                                    <input type="radio" class="" name="service" value="<?php echo e($count->term->name); ?>">
                                    <?php echo e($count->term->name); ?>

                                </label>
                            </div>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <div class="form-group form-group-message">
                        <label><?php echo e(__('Your message')); ?> <span class="required"></span></label>
                        <textarea class="form-control" name="message" placeholder="Start by telling us what product, issue, or what you are trying to achieve. If there is a problem, please provide the details related to your issue." required></textarea>
                    </div>
                </div>
                <div class="col-md-12">
                    <?php if(empty(env('NOCAPTCHA_SITEKEY'))): ?>
                    <p class="text-danger"><i><?php echo e(__('Your captcha is not yet configured*')); ?></i></p>
                    <?php else: ?>
                    <?php echo NoCaptcha::display(); ?>

                    <?php endif; ?>
                </div>
                <div class="col-md-12" style="margin-top:10px">
                    <?php if(empty(env('NOCAPTCHA_SITEKEY'))): ?>
                    <button type="button" class="btn btn-primary" disabled><?php echo e(__('Send Message')); ?></button>
                    <?php else: ?>
                    <button type="submit" class="btn btn-primary"><?php echo e(__('Send Message')); ?></button>
                    <?php endif; ?>
                </div>
            </form>
        </div>
    </div>
</div>
<?php /**PATH /home/netsitfw/public_html/resources/views/frontend/magz/contact.blade.php ENDPATH**/ ?>