<?php if(isset($dataTable)): ?>
    <?php echo e($dataTable->scripts()); ?>

<?php endif; ?>
<script src="<?php echo e(asset('vendor/datatables/buttons.server-side.js')); ?>"></script>
<script>
    "use strict";

    $.ajaxSetup({
        headers: {
            "X-CSRF-TOKEN": $("meta[name=csrf-token]").attr("content")
        }
    })

    // alert delete
    function sweetalert2(table, url) {
        Swal.fire({
            width: "25rem",
            title: "<?php echo e(__('Are you sure?')); ?>",
            text: "<?php echo __('You won\'t be able to revert this!'); ?>",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "<?php echo e(__('Yes, delete it!')); ?>",
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: url,
                    method: "DELETE",
                    success: function(response) {
                        if (response.success) {
                            $("#" + table).DataTable().ajax.reload();
                            Swal.fire({
                                width: "22rem",
                                title: "<?php echo e(__('Deleted!')); ?>",
                                text: response.success,
                                icon: "success",
                                showConfirmButton: false,
                                timer: 1500
                            })
                        } else if (response.info) {
                            toastr.info(response.info)
                        } else if (response.error) {
                            Swal.fire({
                                width: "22rem",
                                title: "<?php echo e(__('Authorize!')); ?>",
                                text: response.error,
                                icon: "error",
                                showConfirmButton: false,
                                timer: 1500
                            })
                        } else {
                            toastr.error(response.authorize)
                        }
                    },
                    error: function(response) {
                        toastr.error(response.responseJSON.message)
                    }
                });
            }
        })
    }

    // multi delete row table
    function multiDelCheckbox(table, url, selectClass) {
        Swal.fire({
            width: "25rem",
            title: "<?php echo e(__('Are you sure?')); ?>",
            text: "<?php echo __('You won\'t be able to revert this!'); ?>",
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            confirmButtonText: "<?php echo e(__('Yes, delete it!')); ?>",
        }).then((result) => {
            if (result.value) {
                let id = [];
                $("."+selectClass+":checked").each(function(){
                    id.push($(this).val());
                });
                if(id.length > 0) {
                    $.ajax({
                        url: url,
                        method: "GET",
                        data: {id:id},
                        success: function(response) {
                            if (response.success) {
                                $("#" + table).DataTable().ajax.reload();
                                Swal.fire({
                                    width: "22rem",
                                    title: "<?php echo e(__('Deleted!')); ?>",
                                    text: response.success,
                                    icon: "success",
                                    showConfirmButton: false,
                                    timer: 1500
                                })
                            } else if (response.info) {
                                toastr.info(response.info)
                            } else if (response.error) {
                                Swal.fire({
                                    width: "22rem",
                                    title: "<?php echo e(__('Authorize!')); ?>",
                                    text: response.error,
                                    icon: "error",
                                    showConfirmButton: false,
                                    timer: 1500
                                });
                            } else {
                                toastr.error(response.authorize)
                            }
                            $("#selectAll").prop("checked",false);
                            $("input[type=checkbox]").prop("checked",false);
                        }
                    });
                }else{
                    Swal.fire({
                        width: "22rem",
                        title: "<?php echo e(__('Error!')); ?>",
                        text: "<?php echo e(__('Please select atleast one checkbox')); ?>",
                        icon: "error",
                        showConfirmButton: false,
                        timer: 1500
                    })
                }
            }
        })
    }

    // function delete button
    function delBtn() {
        $(".confirm").html("<div class=\"spinner-grow spinner-grow-sm\" role=\"status\"><span class=\"sr-only\"><?php echo e(__('Loading')); ?>...</span></div> <?php echo e(__('Deleting')); ?>...");
        $.ajax({
            url: url,
            method: "DELETE",
            success: function(response) {
                console.log(response)
                $("#delete").modal("hide")
                alert_sweet_success(response.success);
                $("#" + table).DataTable().ajax.reload();
                $(".confirm").html("Delete");
            }
        });
    }
</script>
<?php /**PATH /home/mithun/Documents/projects/20220128_pcdrama/resources/views/layouts/partials/_datatables.blade.php ENDPATH**/ ?>