<div class="relative bg-white">
  <div id="contact" class="absolute inset-0">
    <div class="absolute inset-y-0 left-0 w-1/2 bg-gray-50"></div>
  </div>
  <div class="relative max-w-7xl mx-auto lg:grid lg:grid-cols-5">
    <div class="bg-gray-50 py-16 px-4 sm:px-6 lg:col-span-2 lg:px-8 lg:py-24 xl:pr-12">
      <div class="max-w-lg mx-auto">
        <h2 class="text-2xl font-extrabold tracking-tight text-gray-900 sm:text-3xl">
          Have PC Drama?
        </h2>
        <p class="mt-3 text-lg leading-6 text-gray-500">
          <?php echo e(Settings::get('contactdescription')); ?>

        </p>
        <dl class="mt-8 text-base text-gray-500">
          <div>
            <dt class="sr-only">Postal address</dt>
            <dd>
                    <?php echo e($settings->get('street')); ?> <br>
                    <?php echo e($settings->get('city') .', '. $settings->get('state')); ?> <?php echo e($settings->get('postal_code')); ?><br>
            </dd>
          </div>
          <div class="mt-6">
            <dt class="sr-only">Phone number</dt>
            <dd class="flex">
              <!-- Heroicon name: outline/phone -->
              <svg class="flex-shrink-0 h-6 w-6 text-gray-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
              </svg>
              <span class="ml-3">
                <a href="tel:<?php echo e(str_replace('-', '', Settings::get('sitephone'))); ?>"><?php echo e(Settings::get('sitephone')); ?></a>
              </span>
            </dd>
          </div>
          <div class="mt-3">
            <dt class="sr-only">Email</dt>
            <dd class="flex">
              <!-- Heroicon name: outline/mail -->
              <svg class="flex-shrink-0 h-6 w-6 text-gray-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
              </svg>
              <span class="ml-3">
                <a href="mailto:<?php echo e(Settings::get('siteemail')); ?>"><?php echo e(Settings::get('siteemail')); ?></a>
              </span>
            </dd>
          </div>
        </dl>
        <p class="mt-6 text-base text-gray-500">
          Looking for careers?
          <a href="#" class="font-medium text-gray-700 underline">View all job openings</a>.
        </p>
      </div>
    </div>
    <div class="bg-white py-16 px-4 sm:px-6 lg:col-span-3 lg:py-24 lg:px-8 xl:pl-12">
      <div class="max-w-lg mx-auto lg:max-w-none">
        <form class="grid grid-cols-1 gap-y-6" id="contact-form" method="POST" role="form" data-recaptcha="true" enctype="multipart/form-data">
          <div class="form-group form-group-name">
            <label for="<?php echo e(__('Name')); ?>" class="sr-only"><?php echo e(__('Name')); ?><span class="required"></span></label>
            <input type="text" name="name" id="name" autocomplete="name" required class="form-control block w-full shadow-sm py-3 px-4 placeholder-gray-500 focus:ring-indigo-500 focus:border-indigo-500 border-gray-300 rounded-md" placeholder="Full name"><span id="msg-error-name" class="help-block"></span>
          </div>
          <div class="form-group form-group-email">
            <label for="email" class="sr-only"><?php echo e(__('Email')); ?> <span class="required"></span></label>
            <input id="email" name="email" type="email" autocomplete="email" class="form-control block w-full shadow-sm py-3 px-4 placeholder-gray-500 focus:ring-indigo-500 focus:border-indigo-500 border-gray-300 rounded-md" placeholder="Email"><span id="msg-error-email" class="help-block"></span>
          </div>
          <div class="form-group form-group-phone">
            <label for="phone" class="sr-only"><?php echo e(__('Phone Number')); ?></label>
            <input type="text" title="Ten digits" pattern="[0-9]{10}" maxlength="10" minlength="10" name="phone" id="phone" autocomplete="tel" class="form-control block w-full shadow-sm py-3 px-4 placeholder-gray-500 focus:ring-indigo-500 focus:border-indigo-500 border-gray-300 rounded-md" placeholder="Phone"><span id="msg-error-phone" class="help-block"></span>
          </div>
 <div class="col-md-12">
                    <div class="form-group form-group-subject">
                        <label><?php echo e(__('Choose Service')); ?></label>
                        <div class="d-flex" style="display: flex;">
                            <div style="margin-right: 10px;" >
                                <label for="">
                                    <input type="radio" class="" name="service" value="Web Development">
                                    Web Development
                                </label>
                            </div>
                            <div style="margin-right: 10px;" >
                                <label for="">
                                    <input type="radio" class="" name="service" value="Mac help">
                                    Mac help
                                </label>
                            </div>
                            <div style="margin-right: 10px;" >
                                <label for="">
                                    <input type="radio" class="" name="service" value="Email Campaigns">
                                    Email Campaigns
                                </label>
                            </div>
                            <div >
                                <label for="">
                                    <input type="radio" class="" name="service" value="Sales and Marketing">
                                    Sales and Marketing
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
          <div class="form-group form-group-message">
            <label for="message" class="sr-only"><?php echo e(__('Your message')); ?></label>
            <textarea id="message" name="message" rows="8" class="help-block w-full shadow-sm py-3 px-4 placeholder-gray-500 focus:ring-indigo-500 focus:border-indigo-500 border border-gray-300 rounded-md" placeholder="Start by telling us what product, issue, or what you are trying to achieve. If there is a problem, please provide the details related to your issue." required></textarea>
          </div>
              <div class="col-md-12">
                    <?php if(empty(env('NOCAPTCHA_SITEKEY'))): ?>
                    <p class="text-danger"><i><?php echo e(__('Your captcha is not yet configured*')); ?></i></p>
                    <?php else: ?>
                    <?php echo NoCaptcha::display(); ?>

                    <?php endif; ?>
                </div>
          <div class="form-group">
            <button type="button" class="">
              <?php if(empty(env('NOCAPTCHA_SITEKEY'))): ?>
                    <button type="button" class="btn btn-primary text-white" disabled><?php echo e(__('Send Message')); ?></button>
                    <?php else: ?>
                    <button type="submit" class="flex items-center justify-center px-5 py-3 border border-transparent text-base leading-6 font-medium rounded-md bg-blue-700 text-white wow fadeInUp hover:bg-green-700 px-4 rounded focus:outline-none focus:shadow-outline transition duration-150 ease-in-out"><?php echo e(__('Send Message')); ?></button>
                    <?php endif; ?>
            </button>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>

<?php /**PATH /home/seoftgxn/pcdrama.com/resources/views/frontend/magz/twcontact.blade.php ENDPATH**/ ?>