<?php $__env->startSection('canonical'); ?>
<link rel="canonical" href="<?php echo e(url('')); ?>/<?php echo strtolower(str_replace(" ", "-", $post->post_title)); ?>" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<section class="single">
    <div class="container">
        <div class="row">
            <div class="col-md-4 sidebar" id="sidebar">
									<?php if(Request::is('oil-and-gas-investment-calculator')): ?>
									<?php echo $__env->make('tickers.oilticker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									<p>
										Oil and Gas Ticker Widget
									</p>
                <?php echo $__env->make('frontend.magz.template-parts.sidebar-left', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									<?php echo $__env->make('tickers.dowticker', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									<?php else: ?>
                <?php echo $__env->make('frontend.magz.template-parts.sidebar-left', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
									<?php endif; ?>
    				<?php echo $__env->make('frontend.magz.webform', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-8">
                <ol class="breadcrumb">
                    <li><a href="/"><?php echo e(__('Home')); ?></a></li>
                    <li class="active"><?php echo e(Posts::getCategory($post)); ?></li>
                </ol>
                <article class="article main-article">
                    <header>
                        <h1><?php echo e($post->post_title); ?></h1>
                        <ul class="details">
                            <li><?php echo e(__('Posted on')); ?> <?php echo e($post->created_at->format('F d, Y')); ?></li>
                            <li><a href="<?php echo e(route('category.show', Posts::getLinkCategory($post))); ?>"><?php echo e(Posts::getCategory($post)); ?></a></li>
                            <li><?php echo e(__('By')); ?> <span><?php echo e($post->user->name); ?></span></li>
                            <li><?php echo e($post->post_hits); ?> Views</li>
                        </ul>
                    </header>
					  <div class="main">
                        <?php echo $post->post_summary; ?>

                        <figure>
                            <?php if(!empty($post->post_image)): ?>
									 <img src="<?php echo e(route('image.displayImage', $post->post_image)); ?>" title="<?php echo e($post->post_title); ?>" alt="<?php echo e($post->post_title); ?>">
                            <?php endif; ?>
                        </figure>
                        <?php echo $post->post_content; ?>

                    </div>
                    <footer>
                        <div class="col">
                            <ul class="tags">
                                <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><a href="<?php echo e(route('tag.show', $tag->term->slug)); ?>"><?php echo e($tag->term->name); ?></a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <div class="col">
                            <a href="javascript:void(0);" class="love" data-id="<?php echo e($hashids->encode($post->id)); ?>"><i class="ion-android-favorite-outline"></i>
                                <div><?php echo e($post->like); ?></div>
                            </a>
                        </div>
                    </footer>
                </article>
                <div class="sharing">
                    <div class="title"><i class="ion-android-share-alt"></i> <?php echo e(__('Sharing is caring')); ?></div>
                    <?php echo Share::page(request()->url(), $post->post_title, [], '<ul class="social">', '</ul>')
                    ->facebook()
                    ->twitter()
                    ->linkedin()
                    ->whatsapp()
                    ->telegram(); ?>

                </div>
                <div class="line">
                    <div><?php echo e(__('Author')); ?></div>
                </div>
                <div class="author">
                    <figure>
                        <?php if($post->user->photo): ?>
                            <?php if($post->user->photo != 'noavatar.png'): ?>
                                <?php if(Utl::checkFileDisk('avatar/'.$post->user->photo, 'public')): ?>
                                    <img src="<?php echo e(route('author.photo', $post->user->photo)); ?>">
                                <?php else: ?>
                                    <img src="<?php echo e(asset('img/noavatar.png')); ?>" alt="No Image">
                                <?php endif; ?>
                            <?php else: ?>
                            <img src="<?php echo e(asset('img/noavatar.png')); ?>" alt="No Image">
                            <?php endif; ?>
                        <?php else: ?>
                        <img src="<?php echo e(asset('img/noavatar.png')); ?>" alt="No Image">
                        <?php endif; ?>
                    </figure>
                    <div class="details">
                        <div class="job"><?php echo e($post->user->occupation); ?></div>
                        <h3 class="name"><?php echo e($post->user->name); ?></h3>
                        <p><?php if($post->user->about): ?> <?php echo e($post->user->about); ?> <?php else: ?> <i><?php echo e(__('No description')); ?>...</i><?php endif; ?></p>

                        <?php if( $post->user->socialmedia()->exists() ): ?>
                        <ul class="social trp sm">
                            <?php $__currentLoopData = $post->user->socialmedia()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $socmed): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li>
                                <a href="<?php echo e($socmed->pivot->url); ?>" class="<?php echo e($socmed->slug); ?>" target="_blank">
                                    <svg>
                                        <rect /></svg>
                                    <i class="ion-social-<?php echo e($socmed->slug); ?>"></i>
                                </a>
                            </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        <?php endif; ?>
                    </div>
                </div>
                <?php echo $__env->make('frontend.magz.inc._comment-disqus', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
					 
                <?php echo $__env->make('frontend.magz.inc._related-post', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.magz.index', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/pcdramac/domains/macdrama.com/public_html/resources/views/frontend/magz/page/single.blade.php ENDPATH**/ ?>