<?php
use App\Helpers\Settings;
use App\Http\Controllers\Front\AdvertisementController;
use App\Http\Controllers\Front\ArticleController;
use App\Http\Controllers\Front\CategoryController;
use App\Http\Controllers\Front\ContactController;
use App\Http\Controllers\Front\HomeController;
use App\Http\Controllers\Front\PageController;
use App\Http\Controllers\Front\SlugController;
use App\Http\Controllers\Front\TagController;
use App\Models\Post;


use Intervention\Image\Facades\Image;

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\Storage;


/*
|--------------------------------------------------------------------------
| Front Routes
|--------------------------------------------------------------------------
|
*/


Route::redirect('web-development', 'website-development');
Route::redirect('sones', 'https://codepen.io/Justproof/pen/RwLYQVE');

Gate::define('see-sent-emails', function ($user) {
	    return true;
});

Route::get('ogi/{filename}', function ($filename) {
    if (Storage::disk('public')->exists('images/' . $filename)) {
        return Image::make(storage_path('app/public/images/' . $filename))->response();
    } else {
        return Image::make(public_path('img/cover.png'))->response();
    }
})->name('ogi.display');

//ad
Route::get('ad/{filename}', [AdvertisementController::class, 'displayAdImage'])
    ->name('ad.image');

// Feed
Route::feeds();

Route::middleware('public','XSS')->group(function () {
		if(!Request::is('contact')) {
			 Route::get('/{slug}', [SlugController::class, 'view']);
		}

    Route::get('/', [HomeController::class, 'index']);
    Route::get('/news/latest', [ArticleController::class, 'index'])
        ->name('articles.latest');
	Route::get('/contact', [ContactController::class, 'index'])
         ->name('contact');
    Route::get('/news/popular', [ArticleController::class, 'showPopular'])
        ->name('article.popular');
    Route::get('/tag/{term:slug}', [TagController::class, 'index'])
        ->name('tag.show');
	Route::post('/sendcontact', [ContactController::class, 'store'])
			->name('sentcontact');
    Route::patch('/post/react', [ArticleController::class, 'react'])
        ->name('sendreact');

    if (Schema::hasTable('settings')) {
        if (Settings::get('permalink')) {
            if (Settings::get('page_permalink_type')) {
                if (Settings::get('page_permalink_type') == 'with_prefix') {
                    Route::get('/page/{page:post_name}', [PageController::class,'show'])
                        ->name('page.show');
                }
                if (Settings::get('page_permalink_type') == 'page_name') {
                    Route::get('/{page:post_name}', [PageController::class,'show'])
                        ->name('page.show');
                }
            }

            if (Settings::get('category_permalink_type')) {
                if (Settings::get('category_permalink_type') == 'with_prefix_category') {
                    Route::get('/category/{term:slug}', [CategoryController::class, 'index'])
                        ->name('category.show');
                }
                if (Settings::get('category_permalink_type') == 'category_name') {
                    Route::get('/{term:slug}', [CategoryController::class, 'index'])
                        ->name('category.show');
                }
            }

            if (Settings::get('permalink') == "%year%/%month%/%day%") {
                Route::get('/{year}/{month}/{day}/{post:post_name}', function ($year, $month, $day, $post) {
                    $showpost = Post::postType()->whereYear('created_at', '=', $year)
                        ->whereMonth('created_at', '=', $month)
                        ->whereDay('created_at', '=', $day)
                        ->wherePostName($post)
                        ->wherePostLanguage()
                        ->firstOrFail();

                    return app('App\Http\Controllers\Front\ArticleController')->show($showpost);
                })
                    ->name('article.show')
                    ->where('day', '[0-9]+');
            } elseif (Settings::get('permalink') == "%year%/%month%") {
                Route::get('/{year}/{month}/{post:post_name}', function ($year, $month, $post) {
                    $showpost = Post::postType()->whereYear('created_at', '=', $year)
                        ->whereMonth('created_at', '=', $month)
                        ->wherePostName($post)
                        ->firstOrFail();

                    return app('App\Http\Controllers\Front\ArticleController')->show($showpost);
                })
                ->name('article.show');
            } else {
                $word = Settings::get('permalink') != 'post_name' ? Settings::get('permalink') : '';
                $uri = $word . "/{post:post_name}";
                Route::get($uri, function($post) {
                    $showpost = Post::postType()->wherePostName($post)->firstOrFail();;
                    return app('App\Http\Controllers\Front\ArticleController')->show($showpost);
                })
                ->name('article.show');
            }
        }
    }
});

