@extends('adminlte::page')
@section(config('mail-tracker.admin-template.section'))
    <div class="container">
        <div class="row">
            <div class="col-sm-12 mt-2">
                <h1 class="mt-2 pt-2">Mail Tracker  @if(\File::exists(public_path('exports/users-collection.xlsx'))) <a href="{{route('download-export')}}" class="btn btn-success float-right">Download Export</a>  @endif</h1>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <h4 class="text-center">
                    SNS Endpoint: {{ route('mailTracker_SNS') }}
                </h4>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 text-center">
                <form action="{{ route('mailTracker_Search') }}" method="post" class="form-inline">
                    {!! csrf_field() !!}
                    <div class="form-group">
                        <label for="search">
                            Search
                        </label>
                        <input type="text" name="search" id="search" value="{{ session('mail-tracker-index-search') }}">
                    </div>
                    <button type="submit" class="btn btn-default">
                        Search
                    </button>
                    <div class="btn btn-default">
                        <a href="{{ route('mailTracker_ClearSearch') }}">
                            Clear Search
                        </a>
                    </div>
                </form>
                <hr>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12">
                <table class="table table-striped">
                    <tr>
                        <th>Created At</th>
                        <th>Opened At</th>
                        <th>Recipient</th>
                        <th>Opens</th>
                        <th>First Click</th>
                        <th>Clicks</th>
                        <th>Subject</th>
                        <th>Service</th>


                        <th>Name</th>
                        <th>Location</th>
                        <th>Phone</th>


                        <th>View Email</th>
                        <th>Click Report</th>
                    </tr>
                @foreach($emails as $email)
                    <tr class="{{ $email->report_class }}">
                        <td>{{$email->created_at->format(config('mail-tracker.date-format'))}}</td>
                        <td>{{$email->opened_at}}</td>
                        <td>{{$email->recipient}}</td>
                        <td>{{$email->opens}}</td>
                        <td>{{$email->clicked_at}}</td>
                        <td>{{$email->clicks}}</td>
                        <td>{{$email->subject}}</td>
                        <td>{{$email->service}}</td>

                        @if ($email->msg)
                            <td>{{$email->msg->name}}</td>
                            <td><a href="https://www.google.com/maps/place/{{$email->msg->geolocation}}" target="_blank">{{$email->msg->Location}}</a></td>
                            <td>{{$email->msg->phone}}</td>
                        @else
                            <td></td>
                            <td></td>
                            <td></td>
                        @endif

                        <td>
                            <a href="{{route('mailTracker_ShowEmail',$email->id)}}" target="_blank">
                                View
                            </a>
                        </td>
                        <td>
                            @if($email->clicks > 0)
                                <a href="{{route('mailTracker_UrlDetail',$email->id)}}">Url Report</a>
                            @else
                                No Clicks
                            @endif
                        </td>
                    </tr>
                @endforeach
                </table>
            </div>
        </div>
        <div class="row">
            <div class="col-sm-12 text-center">
                {!! $emails->render() !!}
            </div>
        </div>
    </div>
@endsection
