<h2 class="text-center text-2xl pt-4 font-bold">Web Consulting for the Digital Marketplace</h2>
<p class="mt-3 max-w-md mx-auto text-base text-center text-grey-700 sm:text-lg md:mt-5 md:text-md md:max-w-6xl">Hire a professional technician today that will review your site, website errors, or PC Drama. </p>

  <div class="mt-8 bg-white pb-16 sm:mt-12 sm:pb-20 lg:pb-28">
    <div class="relative">
      <div class="absolute inset-0 h-1/2 bg-gray-100"></div>
      <div class="relative max-w-screen-xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="max-w-lg mx-auto rounded-lg shadow-lg overflow-hidden lg:max-w-none lg:flex">
          <div class="bg-white px-6 py-8 lg:flex-shrink-1 lg:p-12">
            <h3 class="text-xl leading-8 font-extrabold text-gray-900 sm:text-2xl sm:leading-9">
@empty($settings->get('site_information'))
<span class="text-blue-700 capitalize">Today is {{ date('l' )}} the {{ date('jS \of F' )}}</span>... <br><span onclick="Calendly.showPopupWidget('https://calendly.com/pcdrama/resume');return false;" onMouseOver="this.style.color='orange'"
   onMouseOut="this.style.color='green'" style="cursor: pointer;">Schedule a call</span> to get a website report by {{ date('l', strtotime('+1 day') )}}.
@else
{{ $settings->get('site_information') }}
@endempty
            </h3>
            <h2 class="text-lg leading-9 font-bold text-black sm:text-md sm:leading-10">Are technical obstacles affecting your life or workplace?</h2>
<p class="mt-6 text-lg text-base leading-6 text-gray-500">
A website audit could uncover compromises that may go unnoticed by an initial site inspection. Lost visitor traffic equates to lost revenue and loss of trust. Allow us to help with Web Consulting, Pay-per-click monitoring, and Email Campaigns.</p>
            <h3 class="text-2xl text-center leading-8 font-extrabold text-gray-900 sm:text-3xl sm:leading-9">

            <a href="tel:{{ str_replace('-', '', $settings->get('sitephone')) }}" class="text-lg hover:text-orange-500 text-blue-500">{{ $settings->get('sitephone')  }}</a>
            </h3>
            <div class="mt-8">
              <div class="flex items-center">
                <h4 class="flex-shrink-0 pr-4 bg-white text-sm leading-5 tracking-wider font-semibold uppercase text-orange-600">
{{ $settings->get('sitename')  }} in
<?php
/*
$ip = $_SERVER['REMOTE_ADDR'];
//$details = json_decode(file_get_contents("http://api.ipstack.com/{$ip}?access_key=bd2a762fb06c4c619e327814b9fe4049"));
            $details = json_decode(file_get_contents("https://api.2ip.me/geo.json?ip={$ip}"));
echo"$details->city, $details->region"
*/
?>
                </h4>
                <div class="flex-1 border-t-2 border-gray-200"></div>
              </div>
              <ul class="mt-8 lg:grid lg:grid-cols-2 lg:col-gap-8 lg:row-gap-5">
        @foreach ($tagCount->skip(0)->take(3) as $count)
                <li class="mt-4 flex items-start lg:col-span-1 lg:mt-0">
                  <div class="flex-shrink-0">
								<i class="h-5 w-5 ion-android-checkbox-outline" style="color: green;"></i>
                  </div>
                  <p class="ml-2 text-lg leading-5 text-gray-700">
                    <a href="{{ route('tag.show', $count->term->slug) }}">{{ $count->term->name }}</a>
                  </p>
                </li>
@endforeach

    @foreach (Posts::recentPosts()->get() as $post)
                <li class="mt-4 flex items-start lg:col-span-1 lg:mt-0">
                  <div class="flex-shrink-0">
								<i class="h-5 w-5 ion-android-checkbox-outline" style="color: green;"></i>
                  </div>
                  <p class="ml-2 text-lg leading-5 text-gray-700">
                    <a href="{{ Settings::getRoutePost($post) }}">{{ $post->post_title }}</a>
                  </p>
                </li>
@endforeach
              </ul>
            </div>
          </div>
          <div class="py-8 px-6 text-center bg-gray-50 lg:flex-shrink-0 lg:flex lg:flex-col lg:justify-center lg:p-12">
            <p class="text-lg leading-6 font-medium text-gray-900">
				  {{ $settings->get('sitename') }}
            </p>
            <div class="mt-4 flex items-center justify-center text-2xl leading-none font-extrabold text-gray-900">
              <a href="tel:{{ str_replace('-', '', $settings->get('sitephone')) }}" class="font-medium text-gray-900">
					{{ $settings->get('sitephone')  }}
              </a>
				</div>
            <div class="mt-4 flex items-center justify-center text-2xl leading-none font-extrabold text-gray-900">
              <span>
            Remote Assistance
              </span>
              <span class="ml-3 text-xl leading-7 font-medium text-gray-500">
              </span>
            </div>
{{--
Learn Link above button
            <p class="mt-4 text-sm leading-5">
              <a href="/inquire-form?title={!! str_replace(' ', '-', strtolower($menu->name)) !!}" class="font-medium text-gray-500 underline">
                Learn {{ $menu->name }}
              </a>
            </p>
--}}
<form name="helpdesksupport" action="https://www.eemotepc.com/rpchd/setupVerifyDownload" method="GET" id="helpdesksupport" target="_blank">
<div class="mt-6">
<input class="border text-center" type="text" pattern="^\d{3}[-]?\d{3}[-]?\d{3}$" maxlength="9" placeholder=" type your 9 digit pin" name="id" required/>
<div class="pt-2 text-center">
<input type="submit" value="Connect to technician" class="px-5 py-3 border border-transparent text-base leading-6 font-medium rounded-md bg-blue-700 text-white wow fadeInUp hover:bg-green-700 px-4 rounded focus:outline-none focus:shadow-outline transition duration-150 ease-in-out" />
</div>
	<div class="pt-8">
		@include('tickers.oilticker')
	</div>
</div>
</form>
            <div class="mt-4 flex items-center justify-center text-2xl leading-none font-extrabold text-gray-900">
              <a href="tel:{{ str_replace('-', '', $settings->get('sitephone')) }}" class="font-medium text-gray-900">
						Widgets and Automation
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
