<div class="line thin"></div>
<div class="page-description">
    <div class="row">
        <div class="col-md-6 col-sm-6">
            <h3>{{ $term->name }}</h3>
            <p>
                {{ $settings->get('contactdescription') }}
            </p>
            <p>
                {{ __('Phone') }}: <span class="bold"><a href="tel:{{ str_replace('-', '', $settings->get('sitephone')) }}">{{ $settings->get('sitephone')  }}</a></span> <br>
                {{ __('Email') }}: <span class="bold"><a href="mailto:{{ $settings->get('siteemail') }}">{{ $settings->get('siteemail') }}</a></span>
                <br>
                <br>
                <p>
                    {{ $settings->get('street') }} <br>
                    {{ $settings->get('city') .' '. $settings->get('postal_code') }} <br>
                    {{ $settings->get('state') .' - '. $settings->get('country') }}
                </p>

            </p>
        </div>
        <div class="col-md-6 col-sm-6">
            <form class="row contact" id="contact-form" method="POST" role="form" data-recaptcha="true" enctype="multipart/form-data">
                <div class="col-md-6">
                    <div class="form-group form-group-name">
                        <label>{{ __('Name') }} <span class="required"></span></label>
                        <input type="name" class="form-control" id="name" name="name" required>
                        <span id="msg-error-name" class="help-block"></span>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group form-group-email">
                        <label>{{ __('Email') }} <span class="required"></span></label>
                        <input type="email" class="form-control" id="email" name="email" required>
                        <span id="msg-error-email" class="help-block"></span>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group form-group-subject" style="display: none;">
                        <label>{{ __('Subject') }}</label>
                        <input type="subject" class="form-control" id="subject" name="subject">
                        <span id="msg-error-subject" class="help-block"></span>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group form-group-subject">
                        <label>{{ __('Phone Number') }}</label>
                        <input type="phone" title="Ten digits" pattern="[0-9]{10}" maxlength="10" minlength="10" class="form-control" id="phone" name="phone">
                        <span id="msg-error-phone" class="help-block"></span>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group form-group-subject">
                        <label>{{ __('Choose Service') }}</label>
                        <div class="d-flex" style="display: flex;">
                            <div style="margin-right: 10px;" >
                                <label for="">
                                    <input type="radio" class="" name="service" value="{{ $term->name }}">
												{{ $term->name }}
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
{{--Removed upload attachment - the timeout was taking greater than 60 seconds.
                <div class="col-md-12">
                    <div class="form-group form-group-subject">
                        <label>{{ __('Attachment') }}</label>
                        <input type="file" class="form-control" name="attachment">
                        <span id="msg-error-attachment" class="help-block"></span>
                    </div>
                </div>
--}}
                <div class="col-md-12">
                    <div class="form-group form-group-message">
                        <label>{{ __('Your message') }} <span class="required"></span></label>
                        <textarea class="form-control" name="message" placeholder="Start by telling us what product, issue, or what you are trying to achieve. If there is a problem, please provide the details related to your issue." required></textarea>
                    </div>
                </div>
                <div class="col-md-12">
                    @empty(env('NOCAPTCHA_SITEKEY'))
                    <p class="text-danger"><i>{{ __('Your captcha is not yet configured*') }}</i></p>
                    @else
                    {!! NoCaptcha::display() !!}
                    @endempty
                </div>
                <div class="col-md-12" style="margin-top:10px">
                    @empty(env('NOCAPTCHA_SITEKEY'))
                    <button type="button" class="btn btn-primary" disabled>{{ __('Send Message') }}</button>
                    @else
                    <button type="submit" class="btn btn-primary">{{ __('Send Message') }}</button>
                    @endempty
                </div>
            </form>
        </div>
    </div>
</div>
