@extends('frontend.magz.index')
@section('canonical')
<link rel="canonical" href="{{ url('')}}/{!! strtolower(str_replace(" ", "-", $page->post_title)); !!}" />
@endsection

@section('content')
<section class="page">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <ol class="breadcrumb">
                    <li><a href="/">{{ __('Home') }}</a></li>
                    <li class="active">{{ $page->post_title }}</li>
                </ol>
                <h1 class="page-title">{{ $page->post_title }}</h1>
                <p class="page-subtitle">{!! $page->post_summary !!}</p>
                <div class="line thin"></div>
                <figure>
                    @if(!empty($page->post_image))
                    <img src="{{ route('image.displayImage', $page->post_image) }}" title="{{ $page->post_title }}" alt="{{ $page->post_title }}">
                    @endif
                </figure>
                <div class="page-description">
                    {!! html_entity_decode($page->post_content) !!}
                </div>
            </div>
        </div>
    </div>
</section>
@stop
