<div class="relative bg-white">
  <div class="absolute inset-0">
    <div class="absolute inset-y-0 left-0 w-1/2 bg-gray-50"></div>
  </div>
  <div class="relative max-w-7xl mx-auto lg:grid lg:grid-cols-5">
    <div class="bg-gray-50 py-16 px-4 sm:px-6 lg:col-span-2 lg:px-8 lg:py-24 xl:pr-12">
      <div class="max-w-lg mx-auto">
        <h2 class="text-2xl font-extrabold tracking-tight text-gray-900 sm:text-3xl">
          Get in touch
        </h2>
        <p class="mt-3 text-lg leading-6 text-gray-500">
Feel free to send me the details with your issue or when the pcdrama first occurred. 
        </p>
        <dl class="mt-8 text-base text-gray-500">
          <div>
{{--
            <dt class="sr-only">Postal address</dt>
            <dd>
              <p>742 Evergreen Terrace</p>
              <p>Springfield, OR 12345</p>
            </dd>
--}}
          </div>
          <div class="mt-6">
            <dt class="sr-only">Phone number</dt>
            <dd class="flex">
              <!-- Heroicon name: outline/phone -->
              <svg class="flex-shrink-0 h-6 w-6 text-gray-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z" />
              </svg>
              <span class="ml-3">
                +1 (720) 334-8196
              </span>
            </dd>
          </div>
          <div class="mt-3">
            <dt class="sr-only">Email</dt>
            <dd class="flex">
              <!-- Heroicon name: outline/mail -->
              <svg class="flex-shrink-0 h-6 w-6 text-gray-400" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z" />
              </svg>
              <span class="ml-3">
                info@pcdrama.com
              </span>
            </dd>
          </div>
        </dl>
{{--
        <p class="mt-6 text-base text-gray-500">
          Looking for careers?
          <a href="#" class="font-medium text-gray-700 underline">View all job openings</a>.
        </p>
--}}
      </div>
    </div>
      @if ($errors->any())
      <div class="alert alert-danger">
          <ul>
              @foreach ($errors->all() as $error)
                  <li>{{ $error }}</li>
              @endforeach
          </ul>
      </div><br />
      @endif
    <div class="bg-white py-16 px-4 sm:px-6 lg:col-span-3 lg:py-24 lg:px-8 xl:pl-12">
      <div class="max-w-lg mx-auto lg:max-w-none">
        <form action="{{url('cppm')}}" method="POST" class="grid grid-cols-1 gap-y-6">
			@csrf
          <div>
            <label for="name" class="sr-only form-group @if ($errors->has('name')) has-error alert alert-danger @endif">Name</label>
         {{Form::text('name', '', ['class' => 'sm-form-control border-form-control block w-full shadow-sm-3 px-4 placeholder-gray-500 focus:ring-indigo-500 focus:border-indigo-500 border-gray-300 rounded-md', 'placeholder'=>'Name'])}}
          </div>
@if ($errors->has('name')) <p class="help-block">{{ $errors->first('name') }}</p> @endif 
          <div>
            <label for="email" class="sr-only form-group @if ($errors->has('name')) has-error alert alert-danger @endif">Email</label>
         {{Form::text('email', '', ['class' => 'sm-form-control border-form-control block w-full shadow-sm py-3 px-4 placeholder-gray-500 focus:ring-indigo-500 focus:border-indigo-500 border-gray-300 rounded-md', 'placeholder'=>'Email'])}}
          </div>
         @if ($errors->has('email')) <p class="help-block">{{ $errors->first('email') }}</p> @endif
          <div>
            <label for="phone" class="sr-only form-group @if ($errors->has('phone')) has-error alert alert-danger @endif">Phone</label>
         {{Form::text('phone', '', ['class' => 'sm-form-control border-form-control block w-full shadow-sm py-3 px-4 placeholder-gray-500 focus:ring-indigo-500 focus:border-indigo-500 border-gray-300 rounded-md', 'placeholder'=>'Phone Number','minlength' =>10, 'maxlength' => 10, 'required' ])}}
          </div>
         @if ($errors->has('phone')) <p class="help-block">{{ $errors->first('phone') }}</p> @endif
          <div>
            <label for="message" class="sr-only">Message</label>
         {{Form::textarea('message', '', ['class' => 'sm-form-control border-form-control block w-full shadow-sm py-3 px-4 placeholder-gray-500 focus:ring-indigo-500 focus:border-indigo-500 border border-gray-300 rounded-md', 'placeholder'=>'Start by telling us what product, issue, or what you are trying to achieve. If there is a problem, please provide the details related to your issue.', 'required'])}}
          </div>
          <div>
            <button type="submit" class="inline-flex justify-center py-3 px-6 border border-transparent shadow-sm text-base font-medium rounded-md text-white bg-indigo-600 hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-indigo-500">
              Submit
            </button>
          </div>
			 <div class="form-group" >
          <label for="ReCaptcha">Recaptcha:</label>
          {!! NoCaptcha::renderJs() !!}
          {!! NoCaptcha::display() !!}
            </div>
        </form>
      </div>
    </div>
  </div>
</div>

