<div class="tab-pane fade" id="web-permalinks" role="tabpanel" aria-labelledby="web-permalinks-tab">
    <form id="form-web-permalinks" action="{{ route('settings.update') }}" method="POST" role="form">
        @method('PATCH')
        @csrf
        <input type="hidden" name="web_permalinks">
        <h5>{{  __('Post Permalinks') }}</h5>
        <hr>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="postname" name="permalink" value="post_name" {{ $settings->permalink === 'post_name' ? 'checked' : '' }}>
                <label for="postname">
                    Post name
                </label>
                <code>{{ url('/') }}/sample-post</code>
            </div>
        </div>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="dayandname" name="permalink" value="%year%/%month%/%day%" {{ $settings->permalink === '%year%/%month%/%day%' ? 'checked' : '' }}>
                <label for="dayandname">
                    Day and name
                </label>
                <code>{{ url('/') }}/{{ now()->year }}/{{ now()->month }}/{{ now()->day }}/sample-post</code>
            </div>
        </div>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="monthandname" name="permalink" value="%year%/%month%" {{ $settings->permalink === '%year%/%month%' ? 'checked' : '' }}>
                <label for="monthandname">
                    Month and name
                </label>
                <code>{{ url('/') }}/{{ now()->year }}/{{ now()->month }}/sample-post</code>
            </div>
        </div>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="custom" name="permalink" value="custom" {{ Settings::get('permalink_type') === 'custom' ? 'checked' : '' }}>
                <label for="custom">
                    Custom
                </label>
                <code>{{ url('/') }}/</code>
                @if(Settings::get('permalink_type') == 'custom')
                    <input type="text" value="{{ Settings::get('permalink') }}" name="custom_input">
                @else
                    <input type="text" value="{{ Settings::get('permalink_old') }}" name="custom_input">
                @endif

                <code>/sample-post</code>
            </div>
        </div>

        <div class="row mt-3">&nbsp;</div>

        <h5>{{ __('Page Permalinks') }}</h5>
        <hr>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="pagename" name="page_permalink" value="page_name" {{ $settings->permalink_page === 'page_name' ? 'checked' : '' }}>
                <label for="pagename">
                    Page name
                </label>
                <code>{{ url('/') }}/sample-page</code>
            </div>
        </div>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="withprefix" name="page_permalink" value="with_prefix" {{ $settings->permalink_page === 'with_prefix' ? 'checked' : '' }}>
                <label for="withprefix">
                    With prefix
                </label>
                <code>{{ url('/') }}/page/sample-page</code>
            </div>
        </div>

        <div class="row mt-3">&nbsp;</div>

        <h5>{{ __('Category Permalinks') }}</h5>
        <hr>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="categoryname" name="category_permalink" value="category_name" {{ $settings->permalink_category === 'category_name' ? 'checked' : '' }}>
                <label for="categoryname">
                    Category name
                </label>
                <code>{{ url('/') }}/sample-category</code>
            </div>
        </div>
        <div class="form-group">
            <div class="icheck-primary d-inline">
                <input type="radio" id="withprefixcategory" name="category_permalink" value="with_prefix_category" {{ $settings->permalink_category === 'with_prefix_category' ? 'checked' : '' }}>
                <label for="withprefixcategory">
                    With prefix
                </label>
                <code>{{ url('/') }}/category/sample-category</code>
            </div>
        </div>

        <div class="mt-3">
            <button id="submit-web-permalinks" type="submit" class="btn btn-info float-right">{{ __('Save') }}</button>
        </div>
    </form>
</div>
