<?php

namespace App\Providers;

use App\Models\Setting;
use Harimayco\Menu\Facades\Menu;
use Illuminate\Support\Facades\Blade;
use Illuminate\Database\Schema\Builder;
use Illuminate\Support\ServiceProvider;
use App\View\Components\Admin\Breadcrumbs;
use ConsoleTVs\Charts\Registrar as Charts;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot(Charts $charts)
    {
        Builder::defaultStringLength(191);
        Blade::component('breadcrumbs', Breadcrumbs::class);
        $charts->register([
            \App\Charts\GoogleAnalyticChart::class,
            \App\Charts\DeviceChart::class
        ]);
        $this->loadViewsFrom(storage_path('app/public/ad'), 'ad');

        $settings = Setting::select(['value', 'name'])->pluck('value', 'name');
        view()->share('settings', $settings);
        view()->share('header_menus', Menu::getByName('header'));
        view()->share('footer_menus', Menu::getByName('footer'));

        $tagCount = \App\Models\TermTaxonomy::with(['term'])->where('taxonomy', 'tag')->withCount('post')->orderBy('post_count', 'desc')->get();
        view()->share('tagCount', $tagCount);

        view()->share('recent_posts', \App\Helpers\Posts::recentPosts()->limit(4)->get());
        session()->put('settings', $settings);

    }
}
