<?php

namespace App\Mail;

use App\User;
use Illuminate\Bus\Queueable;
use Illuminate\Http\Request;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Carbon\Carbon;

class Notify extends Mailable
{
    use Queueable, SerializesModels;
    public $message;
    public $user;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(User $message)
    {

       $this->message = $message;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
$now = Carbon::now()->format('F d, Y');
       return $this->subject("Lead BeeRescue - $now")
                                  ->markdown('emails.Notify');
    }
}
