<?php

namespace App\Mail;
use App\User;

use Illuminate\Bus\Queueable;
use Illuminate\Http\Request;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use Carbon\Carbon;

class CPPM extends Mailable
{
    use Queueable, SerializesModels;
	 public $message;
	 public $user;
     public $msg;

    public function __construct(User $message, $msg)
    {
		 $this->message = $message;
         $this->msg = $msg;
    }

    public function build()
    {
        $attachments = [
            // first attachment
            'https://dallasmosquitoes.com/storage/images/pdf/mosquitoes.pdf' => [
                'as' => 'mosquitoes.pdf',
                'mime' => 'application/pdf',
            ],
        ];

        $now = Carbon::now()->format('F d, Y');
		  $service = $this->msg->service;
		  $name = $this->msg->name;

        $email = $this->markdown('emails.cppm')->subject( $service .' Consultation ' . $now);

        // $attachments is an array with file paths of attachments
        foreach($attachments as $filePath => $fileParameters){
            $email->attach($filePath, $fileParameters);
        }

        $current = $this->msg;

        return $email->withSwiftMessage(function ($msg) use ($current) {
            $msg->getHeaders()->addTextHeader('Msg-Id', $current->id);
        });
    }
}
