<?php

namespace App\Imports\Sheets;

use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\RegistersEventListeners;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\BeforeSheet;

class UserSheetImport implements ToCollection, WithEvents
{
    use Importable, RegistersEventListeners;

    public static function beforeSheet(BeforeSheet $event)
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('users')->delete();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**
     * @param Collection $rows
     * @return void
     */
    public function collection(Collection $rows)
    {
        foreach($rows as $row)
        {
            DB::table('users')->insert([
                'id'                => $row[0],
                'name'              => $row[1],
                'email'             => $row[2],
                'email_verified_at' => $row[3],
                'username'          => $row[4],
                'password'          => $row[5],
                'photo'             => $row[6],
                'occupation'        => $row[7],
                'about'             => $row[8],
                'remember_token'    => $row[9],
                'created_at' => Carbon::create($row[10])->format('Y-m-d H:i:s'),
                'updated_at' => Carbon::create($row[11])->format('Y-m-d H:i:s')
            ]);
        }
    }
}
