<?php

namespace App\Imports\Sheets;

use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\RegistersEventListeners;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\BeforeSheet;

class TermTaxonomySheetImport implements ToCollection, WithEvents
{
    use Importable, RegistersEventListeners;

    public static function beforeSheet(BeforeSheet $event)
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('term_taxonomies')->delete();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**
     * @param Collection $rows
     * @return void
     */
    public function collection(Collection $rows)
    {
        foreach($rows as $row)
        {
            DB::table('term_taxonomies')->insert([
                'id'          => $row[0],
                'term_id'     => $row[1],
                'taxonomy'    => $row[2],
                'description' => $row[3],
                'parent'      => $row[4],
                'count'       => $row[5],
                'created_at' => Carbon::create($row[6])->format('Y-m-d H:i:s'),
                'updated_at' => Carbon::create($row[7])->format('Y-m-d H:i:s')
            ]);
        }
    }
}
