<?php

namespace App\Imports\Sheets;

use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\RegistersEventListeners;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\BeforeSheet;

class PostSheetImport implements ToCollection, WithEvents
{
    use Importable, RegistersEventListeners;

    public static function beforeSheet(BeforeSheet $event)
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        DB::table('posts')->delete();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**
     * @param Collection $rows
     * @return void
     */
    public function collection(Collection $rows)
    {
        foreach($rows as $row)
        {
            DB::table('posts')->insert([
                'id'               => $row[0],
                'post_title'       => $row[1],
                'post_name'        => $row[2],
                'post_summary'     => $row[3],
                'post_content'     => $row[4],
                'meta_description' => $row[5],
                'meta_keyword'     => $row[6],
                'post_status'      => $row[7],
                'post_visibility'  => $row[8],
                'post_author'      => $row[9],
                'post_type'        => $row[10],
                'post_guid'        => $row[11],
                'post_hits'        => $row[12] == null ? '0' : $row[12],
                'like'             => $row[13] == null ? '0' : $row[13],
                'post_image'       => $row[14],
                'post_image_meta'  => $row[15],
                'post_mime_type'   => $row[16] == null ? '' : $row[16],
                'comment_status'   => $row[17] == null ? 'open' : $row[17],
                'comment_count'    => $row[18] == null ? '0' : $row[18],
                'created_at' => Carbon::create($row[19])->format('Y-m-d H:i:s'),
                'updated_at' => Carbon::create($row[20])->format('Y-m-d H:i:s')
            ]);
        }
    }
}
