<?php

namespace App\Imports\Sheets;

use App\Models\Advertisement;
use Illuminate\Support\Carbon;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\Importable;
use Maatwebsite\Excel\Concerns\RegistersEventListeners;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\BeforeSheet;

class AdvertisementSheetImport implements ToCollection, WithEvents
{
    use Importable, RegistersEventListeners;

    public static function beforeSheet(BeforeSheet $event)
    {
        DB::statement('SET FOREIGN_KEY_CHECKS=0;');
        Advertisement::query()->delete();
        DB::statement('SET FOREIGN_KEY_CHECKS=1;');
    }

    /**
     * @param Collection $rows
     * @return void
     */
    public function collection(Collection $rows)
    {
        foreach($rows as $row)
        {
            DB::table('advertisements')->insert([
                'id'         => $row[0],
                'name'       => $row[1],
                'type'       => $row[2],
                'url'        => $row[3],
                'image'      => $row[4],
                'size'       => $row[5],
                'active'     => $row[6] == null ? 'y' : $row[6],
                'created_at' => Carbon::create($row[7])->format('Y-m-d H:i:s'),
                'updated_at' => Carbon::create($row[8])->format('Y-m-d H:i:s')
            ]);
        }
    }
}
