<?php

namespace App\Http\Controllers\Front;

use App\Helpers\Settings;
use App\Http\Controllers\Controller;
use App\Models\Post;
use App\Models\Term;
use App\Models\TermTaxonomy;
use Artesaos\SEOTools\Facades\SEOTools;
use Hashids\Hashids;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\View\View;

class TagController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Application|Factory|View
     */
    public function index(Term $term)
    {
        $termTaxonomy = $term->taxonomy;

        // $termTaxonomy = TermTaxonomy::find($term_taxonomy_id);

        $paginate = $termTaxonomy->post()->paginate(8);

        $hashids = new Hashids();

        $image = (Settings::get('ogimage')) ? route('ogi.display', Settings::get('ogimage')) :
            asset('img/cover.png');

        SEOTools::setTitle(Settings::get('sitename'). " - Tag: " . $term->name);
        SEOTools::setDescription(Settings::get('sitedescription'));
        SEOTools::metatags()->setKeywords(Settings::get('metakeyword'). " | " . $term->name);
        SEOTools::setCanonical(Settings::get('siteurl'));
        SEOTools::opengraph()->setTitle(Settings::get('sitename') . $term->name);
        SEOTools::opengraph()->setDescription(Settings::get('sitedescription'). " " . $term->name);
        SEOTools::opengraph()->setUrl(Settings::get('siteurl'));
        SEOTools::opengraph()->setSiteName(Settings::get('company_name'));
        SEOTools::opengraph()->addImage($image);
        SEOTools::twitter()->setType('summary_large_image');
        SEOTools::twitter()->setSite('@' . Settings::get('twitter'));
        SEOTools::twitter()->setTitle(Settings::get('sitename'). " " . $term->name);
        SEOTools::twitter()->setDescription(Settings::get('sitedescription'). " " . $term->name);
        SEOTools::twitter()->setImage($image);
        SEOTools::jsonLd()->setTitle(Settings::get('sitename') . $term->name);
        SEOTools::jsonLd()->setDescription(Settings::get('sitedescription'). " " . $term->name);
        SEOTools::jsonLd()->setType('WebPage');
        SEOTools::jsonLd()->setUrl(Settings::get('siteurl'));
        SEOTools::jsonLd()->addImage($image);

        return view(Settings::active_theme('page/tag'), compact(
            'term',
            'termTaxonomy',
            'paginate',
            'hashids'
        ));
    }
}
