<?php

namespace App\Http\Controllers\Front;

use App\Helpers\Settings;
use App\Http\Controllers\Controller;
use App\Models\Post;
use App\Models\Term;
use Illuminate\Http\Request;

class SlugController extends Controller
{
    protected $PageController;
    protected $CategoryController;
    protected $ArticleController;

    public function __construct(PageController $PageController, CategoryController $CategoryController, ArticleController $ArticleController)
    {
        $this->PageController = $PageController;
        $this->CategoryController = $CategoryController;
        $this->ArticleController = $ArticleController;
    }

    public function view(Request $request, $slug)
    {
        if ( $post = Post::postType()->wherePostName($slug)->exists()) {
            if (Settings::get('permalink_type')) {
                if (Settings::get('permalink_type') == 'post_name') {
                    $rpost = Post::postType()->wherePostName($slug)->first();
                    return $this->ArticleController->show($rpost);
                } else {
                    return abort(404);
                }
            }
        } else if ($page = Post::ofType('page')->wherePostName($slug)->exists()) {

            if (Settings::get('page_permalink_type')) {
                if (Settings::get('page_permalink_type') == 'page_name') {
                    $rpage = Post::ofType('page')->wherePostName($slug)->first();
                    return $this->PageController->show($rpage);
                } else {
                    return abort(404);
                }
            }
        } else if ($category = Term::category()->whereSlug($slug)->exists()) {
            if (Settings::get('category_permalink_type')) {
                if (Settings::get('category_permalink_type') == 'category_name') {
                    $rcategory = Term::Category()->whereSlug($slug)->first();
                    return $this->CategoryController->index($rcategory);
                } else {
                    return abort(404);
                }
            }
            return redirect()->route('category.show', [$slug]);
        } else {
            return abort(404);
        }
    }
}
