<?php

namespace App\Http\Controllers\Front;

use App\Helpers\Settings;
use App\Http\Controllers\Controller;
use App\Models\Contact;
use App\Models\Post;
use App\Models\Setting;
use App\Models\TermTaxonomy;
use Artesaos\SEOTools\Facades\SEOTools;
use Illuminate\Contracts\Foundation\Application;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;
use App\Jobs\SendEmailJob;
use App\Models\Message;

class ContactController extends Controller
{
    /**
     * @param $name
     * @return mixed
     */
    public function get_setting($name)
    {
        $get_settings = Setting::get();
        $value = $get_settings->whereIn('name', $name)->first()->value;
        return $value;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Application|Factory|View
     */
    public function index()
    {
        $image = (Settings::get('ogimage')) ? route('ogi.display', Settings::get('ogimage')) :
            asset('img/cover.png');

        SEOTools::setTitle("Contact's Page");
        SEOTools::setDescription("Contact's Page");
        SEOTools::metatags()->setKeywords("Contact's Page");
        SEOTools::setCanonical(url("/contact"));
        SEOTools::opengraph()->setUrl(url("/contact"));
        SEOTools::opengraph()->setSiteName(Settings::get('company_name'));
        SEOTools::opengraph()->addImage($image);
        SEOTools::twitter()->setType('summary_large_image');
        SEOTools::twitter()->setSite('@' . Settings::get('twitter'));
        SEOTools::twitter()->setTitle("Contact's Page");
        SEOTools::twitter()->setDescription("Contact's Page");
        SEOTools::twitter()->setImage($image);
        SEOTools::jsonLd()->setTitle("Contact's Page");
        SEOTools::jsonLd()->setDescription("Contact's Page");
        SEOTools::jsonLd()->setType('WebPage');
        SEOTools::jsonLd()->setUrl(url("/contact"));
        SEOTools::jsonLd()->addImage($image);

        return view(Settings::active_theme('page/contact'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param Request $request
     * @return JsonResponse
     */
    public function store(Request $request)
    {

        $data = $request->validate([
            'name' => 'required|string|min:2|max:100',
            'email' => 'required|email',
            'phone' => 'nullable',
            'subject' => 'nullable',
            'message' => 'required',
            'service' => 'nullable',
            'g-recaptcha-response' => 'required|captcha'
        ]);

        $save = Contact::create($data);

        if ($save) {
            $attach_name = '';
            if($request->hasFile('attachment')) {
                $attach_name = rand(1,1000).str_random(4).time().'.'.$request->attachment->extension();
                $request->attachment->move(public_path('contact_attach'), $attach_name);
            }
            $ip = request()->ip();
            $details = json_decode(file_get_contents("http://api.ipstack.com/{$ip}?access_key=097bc61dc1ef44e70817401f0150d07c"));
            $message = new Message;
            $save->update(['attachment' => $attach_name]);
            $message->attachment = $attach_name; new Message;
            $message->name = $request->input('name'); new Message;
            $message->email =  $request->input('email'); new Message;
            $message->phone =  $request->input('phone'); new Message;
            $message->subject =  $request->input('subject'); new Message;
            $message->message =  $request->input('message'); new Message;
            $message->service =  $request->input('service'); new Message;
            $message->location = "".$details->city.", ".$details->region_name."";
				$message->geolocation = $details->latitude.",".$details->longitude;
            $message->save();
            dispatch(new SendEmailJob($message));
//            return redirect()->back()->with('msg', 'sent');
            return response()->json([
                'status' => true,
					 'data' => 'Thank you, ' .explode(" ", trim($message->name)) [0] . '! Your Message has been sent.'
            ]);
        } else {
            return response()->json([
                'status' => false,
                'data' => 'Message could not be sent'
            ]);
        }
    }
}
