<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithHeadings;

class EmailMSgExport implements FromCollection, WithHeadings, WithMapping
{
    /**
    * @return \Illuminate\Support\Collection
    */
    public function collection()
    {
        $details = \DB::table('sent_emails')->leftJoin('messages', 'messages.id', 'sent_emails.msg_id')->select('sent_emails.created_at', 'sent_emails.opened_at', 'sent_emails.recipient_email', 'sent_emails.opens', 'sent_emails.clicked_at', 'sent_emails.clicks', 'sent_emails.subject', 'messages.service', 'messages.geolocation', 'messages.name', 'messages.Location', 'messages.ip', 'messages.phone')->get();
        return $details;
    }
    
    public function headings(): array
    {
        return [
            'Created At',
            'Opened At',
            'Recipient',
            'Opens',
            'First Click',
            'Clicks',
            'Subject',
            'Service',
            'Name',
            'Location',
            'Map',
            'Phone',
        ];
    }
    
    public function map($row): array
    {
        return [
            $row->created_at,
            $row->opened_at,
            $row->recipient_email,
            $row->opens,
            $row->clicked_at,
            $row->clicks,
            $row->subject,
            $row->service,
            $row->name,
            $row->Location,
            "https://www.google.com/maps/place/".$row->geolocation,
            $row->phone,
        ];
    }
}
